﻿var dataStore = window.sessionStorage;
var languageCode = window.navigator.userLanguage || window.navigator.language;

function IPBanPro_GetDataStoreItem(key, defaultValue = 0)
{
    try
    {
        return dataStore.getItem(key);
    }
    catch (e)
    {
        return defaultValue;
    }
}

function IPBanPro_CreateTabs(element, key)
{
    var oldIndex = IPBanPro_GetDataStoreItem(key);
    $(element).tabs
    ({
        // The zero-based index of the panel that is active (open)
        active: oldIndex,

        // Triggered after a tab has been activated
        activate: function (event, ui)
        {
            var newIndex = ui.newTab.parent().children().index(ui.newTab);
            dataStore.setItem(key, newIndex);
            IPBanPro_UpdateAutoHeightTextBoxes();
        }
    });
    $(element).show();
}

function IPBanPro_SaveScrollPosition(key)
{
    $(window).scroll(function ()
    {
        dataStore.setItem(key, $(this).scrollTop());
    });

    $(function ()
    {
        let pos = IPBanPro_GetDataStoreItem(key);
        $(window).scrollTop(pos);
    });
}

function IPBanPro_ReplaceStringRange(text, startIndex, endIndex, newText)
{
    return text.substring(0, startIndex) + newText + text.substring(endIndex);
}

function IPBanPro_GetStartEndIndexCommaSeparatedTextItem(elem)
{
    var text = $(elem).val();
    var index = $(elem).prop('selectionStart');
    var startIndex = Math.max(0, index - 1);
    var endIndex = index;
    while (startIndex > 0)
    {
        if (text[startIndex] === ',')
        {
            startIndex++;
            break;
        }
        startIndex--;
    }
    while (endIndex < text.length)
    {
        if (text[endIndex] === ',')
        {
            break;
        }
        endIndex++;
    }
    return { startIndex: startIndex, endIndex: endIndex };
}

function IPBanPro_ExtractCurrentCommaSeparatedTextItem(elem)
{
    var idx = IPBanPro_GetStartEndIndexCommaSeparatedTextItem(elem);
    var elemText = $(elem).val();
    return elemText.substring(idx.startIndex, idx.endIndex);
}

function IPBanPro_SetCurrentCommaSeparatedTextItem(elem, text)
{
    var elemText = $(elem).val();
    var idx = IPBanPro_GetStartEndIndexCommaSeparatedTextItem(elem);
    var newText = IPBanPro_ReplaceStringRange(elemText, idx.startIndex, idx.endIndex, text);
    $(elem).val(newText);
    $(elem).trigger("autocomplete_selected");
}

// example formatter: function(item) { return "<div>" + item.countryName + "</div>" }
function IPBanPro_AutocompleteOptions(elem, url, dataRoot, maxCount, formatter)
{
    var lastWasArrow = false;
    var autocomplete =
    {
        autoFocus: true,
        focus: function (event, ui)
        {
            return false;//event.preventDefault();
        },
        source: function(request, response)
        {
            $.get(url,
            {
                languageCode: languageCode,
                query: request.term
            }, function (data)
            {
                if (lastWasArrow)
                {
                    response([]);
                }
                else
                {
                    var array = data[dataRoot].slice(0, maxCount);
                    for (var i = 0; i < array.length; i++)
                    {
                        array[i].label = formatter(array[i]);
                    }
                    response(array);
                }
            });
        },
        minLength: 1
    };

    $(elem).on("keyup", function (e)
    {
        var code = e.keyCode || e.which;
        if (code === 37 || code === 39)
        {
            lastWasArrow = true;
        }
        else
        {
            lastWasArrow = false;
        }
    });

    return autocomplete;
}

function IPBanPro_CreateAccordion(elem, hide)
{
    $(elem).find('h3').each(function ()
    {
        if (hide)
        {
            $(this).next().slideUp(0);
        }
    }).unbind('click').click(function (e)
    {
        var current = this;
        var hasShow = $(this).hasClass('show');
        e.preventDefault();

        // hide other accordions
        $(this).parent().parent().find('h3').each(function (idx)
        {
            if ($(this).hasClass('show'))
            {
                $(this).removeClass('show');
                $(this).next().slideUp(350);
            }
        });

        if (!hasShow)
        {
            // show this element
            $(this).addClass('show');
            $(this).next().slideDown(350, function ()
            {
                $(this).parent().find('*').trigger('show');
            });
            $(this).parent().find('*').trigger('show');
        }
    });
}


function IPBanPro_ReplaceArrayString(str, idx)
{
    return str === null || str === undefined ? null :
        str.replace(/_[0-9]+_/g, '_' + idx.toString() + '_')
        .replace(/\[[0-9]+\]/g, '[' + idx.toString() + ']')
        .replace(/_[0-9]*$/g, '_' + idx.toString());
}

function IPBanPro_ReplaceArrayIdName(elem, idx)
{
    var newId = IPBanPro_ReplaceArrayString($(elem).attr('id'), idx);
    var newName = IPBanPro_ReplaceArrayString($(elem).attr('name'), idx);
    var newFor = IPBanPro_ReplaceArrayString($(elem).attr('for'), idx);
    if (newId !== null && newId !== undefined)
    {
        $(elem).attr('id', newId);
    }
    if (newName !== null && newName !== undefined)
    {
        $(elem).attr('name', newName);
    }
    if (newFor !== null && newFor !== undefined)
    {
        $(elem).attr('for', newFor);
    }
}

function IPBanPro_ReplaceArraysIdName(selector)
{
    $(selector).each(function (i)
    {
        IPBanPro_ReplaceArrayIdName(this, i);
        $(this).find('*').each(function (j)
        {
            IPBanPro_ReplaceArrayIdName(this, i);
        });
    });
}

function IPBanPro_UpdateAutoHeightTextBoxes()
{
    $('textarea.autoheight').each(function ()
    {
        var horizontalScrollbarHeight = this.offsetHeight - this.clientHeight;
        $(this).height(5);
        $(this).height(this.scrollHeight + horizontalScrollbarHeight + 10);
    });
}

function IPBanPro_UnbanIPAddresses(ips, shouldWhitelist)
{
    if (shouldWhitelist == null)
    {
        shouldWhitelist = false;
    }
    let ipAddresses = encodeURIComponent(ips);
    var url = '/api/UnbanIPAddresses?ipAddresses=' + ipAddresses;
    if (shouldWhitelist)
    {
        url += "&whitelist=true";
    }
    $.get(url, function (data)
    {
        if (shouldWhitelist)
        {
            alert('The requested ip addresses are now unblocked and whitelisted');
        }
        else
        {
            alert('The requested ip addresses are now unblocked');
        }
        if (success != null)
        {
            success();
        }
    }).fail(function (jqXHR, textStatus, error)
    {
        if (shouldWhitelist)
        {
            alert('Error unblocking and whitelisting ip addresses: ' + error);
        }
        else
        {
            alert('Error unblocking ip addresses: ' + error);
        }
    });
}

function IPBanPro_ShowUnbanDialog(ips, elem)
{
    var dialog = $('<p>Choose option for ip address ' + ips + '</p>').dialog({
        width: '500px',
        buttons:
        {
            "Unblock": function ()
            {
                IPBanPro_UnbanIPAddresses(ips, false);
                if (elem != null)
                {
                    $(elem).remove();
                }
                dialog.dialog('close');
            },
            "Whitelist": function ()
            {
                IPBanPro_UnbanIPAddresses(ips, true);
                if (elem != null)
                {
                    $(elem).remove();
                }
                dialog.dialog('close');
            },
            "Cancel": function ()
            {
                dialog.dialog('close');
            }
        }
    });
    return false;
}

function IPBanPro_ObserveDom(query, callback)
{
    // Select the node that will be observed for mutations
    //var targetNode = document.querySelector(query);
    var targetNode = document.querySelector(query);

    // Options for the observer (which mutations to observe)
    var config = { attributes: false, characterData: true, childList: true, subtree: true };

    // Callback function to execute when mutations are observed
    var innerCallback = function(mutationsList)
    {
        callback();
    };

    // Create an observer instance linked to the callback function
    var observer = new MutationObserver(innerCallback);

    // Start observing the target node for configured mutations
    observer.observe(targetNode, config);

    // Later, you can stop observing
    // observer.disconnect();

    return observer;
}

function IPBanPro_UpdateIPList(name)
{
    var elemHidden = $('#' + name);
    var elemHiddenValue = '';
    var elemDiv = $('#' + name + '_container').first();
    var rows = elemDiv.find("tbody tr").each(function (idx, elemRow)
    {
        if (idx !== 0)
        {
            elemHiddenValue += ',';
        }
        var tds = $(elemRow).find("td").each(function (idx2, elemTd)
        {
            // don't include the delete button
            if (idx2 < 3)
            {
                if (idx2 !== 0)
                {
                    elemHiddenValue += '?';
                }
                elemHiddenValue += $(elemTd).text();
            }
        });
    });
    elemHidden.val(elemHiddenValue);
}

function IPBanPro_AddIPList(name, deleteText, enterIpText, enterNotesText)
{
    var ip = prompt(enterIpText);
    if (ip == null || ip === '')
    {
        return;
    }
    var notes = prompt(enterNotesText);
    if (notes == null)
    {
        return;
    }
    var d = new Date();
    var timestamp = d.toISOString();

    // start a tr
    var elem = $('#' + name + '_container');
    var idx = elem.find('tbody tr').length.toString();
    var trId = name + '_' + idx;
    var trow = $('<tr>');
    trow.attr('id', trId);

    // append ip address
    var ipTd = $('<td></td>');
    ipTd.text(ip.replace('?', '').replace(',', ''));

    // append timestamp
    var timestampTd = $('<td></td>');
    timestampTd.text(timestamp.replace('?', '').replace(',', ''));

    // append notes
    var notesTd = $('<td></td>');
    notesTd.text(notes.replace('?', '').replace(',', ''));

    // append delete button
    var deleteButtonTd = $('<td></td>');
    var deleteButtonHtml = '<input type=\'button\' class=\'button fullWidth delete-color buttonTinyPadding\' onclick=\'$(\"#' + trId + '\").remove(); return false;\' value=\'' + deleteText + '\' />';
    deleteButtonTd.html(deleteButtonHtml);

    // append all td elements
    trow.append(ipTd);
    trow.append(timestampTd);
    trow.append(notesTd);
    trow.append(deleteButtonTd);
    trow.append('</tr>');

    // append tr element
    var tbody = elem.find('tbody').first();
    tbody.append(trow);
}

$(function ()
{
    function IPBanPro_OnLoad()
    {
        function IPBanPro_UpdateStickyHeaders()
        {
            $('.stickyHeaders thead td, .scrollArea thead td').each(function (idx, elem)
            {
                // set td element (2nd row) top to height of first row (th elements)
                var jqueryElem = $(elem);
                var height = jqueryElem.parent().parent().children().first().height();
                jqueryElem.css('top', height);
            });
        }
        IPBanPro_UpdateAutoHeightTextBoxes();
        $(document).on('show resize input DOMNodeInserted', 'textarea.autoheight', function ()
        {
            var horizontalScrollbarHeight = this.offsetHeight - this.clientHeight;
            $(this).height(5);
            $(this).height(this.scrollHeight + horizontalScrollbarHeight + 10);
        });
        $(document).tooltip();
        const widgetOptions =
        {
            filter_childRows: true,
            filter_cssFilter: 'tablesorter-filter',
            filter_startsWith: false,
            filter_ignoreCase: true,
            filter_hideFilters: true
        };
        $('.defaultTable').tablesorter
        ({
            theme: 'dark',
            widgets: ["filter"],
            widgetOptions: widgetOptions
        });
        $(window).resize(function ()
        {
            IPBanPro_UpdateStickyHeaders();
        });
        IPBanPro_UpdateStickyHeaders();
    }
    IPBanPro_OnLoad();
});

$(document).on
({
    mouseenter: function ()
    {
        $(this).attr('title', $(this).html());
    },
    mouseleave: function ()
    {
        $(this).attr('title', '');
    }
}, "td span");